module net.BurtonRadons.parse.dispatch;

/** Multi-method dispatch for the declarations, expressions, statements, and scopes. */

class Dispatch
{
    /** Call the correct dispatch method for the object.  If you add to this,
      * remember that subclasses need to be tested first.
      */

    bit base (Object o)
    {
        if (o === null) return true;
        if (cast (StructExp) o) return call (cast (StructExp) o);
        if (cast (AssertExp) o) return call (cast (AssertExp) o);
        if (cast (BitwiseXorExp) o) return call (cast (BitwiseXorExp) o);
        if (cast (BitwiseXorAssignExp) o) return call (cast (BitwiseXorAssignExp) o);
        if (cast (BitwiseOrAssignExp) o) return call (cast (BitwiseOrAssignExp) o);
        if (cast (BitwiseAndAssignExp) o) return call (cast (BitwiseAndAssignExp) o);
        if (cast (ModExp) o) return call (cast (ModExp) o);
        if (cast (ModAssignExp) o) return call (cast (ModAssignExp) o);
        if (cast (UnsignedRightShiftAssignExp) o) return call (cast (UnsignedRightShiftAssignExp) o);
        if (cast (RightShiftAssignExp) o) return call (cast (RightShiftAssignExp) o);
        if (cast (MulAssignExp) o) return call (cast (MulAssignExp) o);
        if (cast (ArrayLengthExp) o) return call (cast (ArrayLengthExp) o);
        if (cast (ExpStatement) o) return call (cast (ExpStatement) o);
        if (cast (Module) o) return call (cast (Module) o);
        if (cast (BitwiseAndExp) o) return call (cast (BitwiseAndExp) o);
        if (cast (BitwiseOrExp) o) return call (cast (BitwiseOrExp) o);
        if (cast (UnsignedRightShiftExp) o) return call (cast (UnsignedRightShiftExp) o);
        if (cast (RightShiftExp) o) return call (cast (RightShiftExp) o);
        if (cast (LeftShiftAssignExp) o) return call (cast (LeftShiftAssignExp) o);
        if (cast (LeftShiftExp) o) return call (cast (LeftShiftExp) o);
        if (cast (CatAssignExp) o) return call (cast (CatAssignExp) o);
        if (cast (CatExp) o) return call (cast (CatExp) o);
        if (cast (InExp) o) return call (cast (InExp) o);
        if (cast (LogicalAndExp) o) return call (cast (LogicalAndExp) o);
        if (cast (LogicalOrExp) o) return call (cast (LogicalOrExp) o);
        if (cast (CompareExp) o) return call (cast (CompareExp) o);
        if (cast (IdentityEqualsExp) o) return call (cast (IdentityEqualsExp) o);
        if (cast (EqualsExp) o) return call (cast (EqualsExp) o);
        if (cast (IndexExp) o) return call (cast (IndexExp) o);
        if (cast (DivAssignExp) o) return call (cast (DivAssignExp) o);
        if (cast (DivExp) o) return call (cast (DivExp) o);
        if (cast (MulExp) o) return call (cast (MulExp) o);
        if (cast (SubAssignExp) o) return call (cast (SubAssignExp) o);
        if (cast (SubExp) o) return call (cast (SubExp) o);
        if (cast (AddAssignExp) o) return call (cast (AddAssignExp) o);
        if (cast (AddExp) o) return call (cast (AddExp) o);
        if (cast (AssignExp) o) return call (cast (AssignExp) o);
        if (cast (CommaExp) o) return call (cast (CommaExp) o);
        if (cast (BinaryExp) o) return call (cast (BinaryExp) o);
        if (cast (LogicalNotExp) o) return call (cast (LogicalNotExp) o);
        if (cast (PointerExp) o) return call (cast (PointerExp) o);
        if (cast (AddressExp) o) return call (cast (AddressExp) o);
        if (cast (PreDecExp) o) return call (cast (PreDecExp) o);
        if (cast (PreIncExp) o) return call (cast (PreIncExp) o);
        if (cast (PostDecExp) o) return call (cast (PostDecExp) o);
        if (cast (PostIncExp) o) return call (cast (PostIncExp) o);
        if (cast (NegExp) o) return call (cast (NegExp) o);
        if (cast (PreUnaryExp) o) return call (cast (PreUnaryExp) o);
        if (cast (Symbol) o) return call (cast (Symbol) o);
        if (cast (Scope) o) return call (cast (Scope) o);
        if (cast (UnaryExp) o) return call (cast (UnaryExp) o);
        if (cast (ConditionalExp) o) return call (cast (ConditionalExp) o);
        if (cast (ArrayExp) o) return call (cast (ArrayExp) o);
        if (cast (DotIdExp) o) return call (cast (DotIdExp) o);
        if (cast (SliceExp) o) return call (cast (SliceExp) o);
        if (cast (TypeDotIdExp) o) return call (cast (TypeDotIdExp) o);
        if (cast (CastExp) o) return call (cast (CastExp) o);
        if (cast (NewExp) o) return call (cast (NewExp) o);
        if (cast (CallExp) o) return call (cast (CallExp) o);
        if (cast (NullExp) o) return call (cast (NullExp) o);
        if (cast (SuperExp) o) return call (cast (SuperExp) o);
        if (cast (ThisExp) o) return call (cast (ThisExp) o);
        if (cast (IdExp) o) return call (cast (IdExp) o);
        if (cast (StringExp) o) return call (cast (StringExp) o);
        if (cast (FalseExp) o) return call (cast (FalseExp) o);
        if (cast (TrueExp) o) return call (cast (TrueExp) o);
        if (cast (ImaginaryExp) o) return call (cast (ImaginaryExp) o);
        if (cast (FloatExp) o) return call (cast (FloatExp) o);
        if (cast (IntegerExp) o) return call (cast (IntegerExp) o);
        if (cast (Expression) o) return call (cast (Expression) o);
        if (cast (VariableDeclaration) o) return call (cast (VariableDeclaration) o);
        if (cast (UnittestDeclaration) o) return call (cast (UnittestDeclaration) o);
        if (cast (ConstructorDeclaration) o) return call (cast (ConstructorDeclaration) o);
        if (cast (FunctionDeclaration) o) return call (cast (FunctionDeclaration) o);
        if (cast (AliasDeclaration) o) return call (cast (AliasDeclaration) o);
        if (cast (EnumDeclaration) o) return call (cast (EnumDeclaration) o);
        if (cast (ClassDeclaration) o) return call (cast (ClassDeclaration) o);
        if (cast (StructDeclaration) o) return call (cast (StructDeclaration) o);
        if (cast (AggregateDeclaration) o) return call (cast (AggregateDeclaration) o);
        if (cast (ImportDeclaration) o) return call (cast (ImportDeclaration) o);
        if (cast (Declaration) o) return call (cast (Declaration) o);
        if (cast (ThrowStatement) o) return call (cast (ThrowStatement) o);
        if (cast (DefaultStatement) o) return call (cast (DefaultStatement) o);
        if (cast (CaseStatement) o) return call (cast (CaseStatement) o);
        if (cast (SwitchStatement) o) return call (cast (SwitchStatement) o);
        if (cast (WhileStatement) o) return call (cast (WhileStatement) o);
        if (cast (ReturnStatement) o) return call (cast (ReturnStatement) o);
        if (cast (IfElseStatement) o) return call (cast (IfElseStatement) o);
        if (cast (BlockStatement) o) return call (cast (BlockStatement) o);
        if (cast (LabelStatement) o) return call (cast (LabelStatement) o);
        if (cast (ForStatement) o) return call (cast (ForStatement) o);
        if (cast (WithStatement) o) return call (cast (WithStatement) o);
        if (cast (VolatileStatement) o) return call (cast (VolatileStatement) o);
        if (cast (Statement) o) return call (cast (Statement) o);
        return callobj (cast (Object) o);
    }

    bit baselist (Object [] list)
    {
        for (int c; c < list.length; c ++)
            if (!base (list [c]))
                return false;

        return true;
    }

/+
#ifndef DOXYGEN_SHOULD_SKIP_THIS
+/

    import net.BurtonRadons.parse.declaration;
    import net.BurtonRadons.parse.expression;
    import net.BurtonRadons.parse.scope;
    import net.BurtonRadons.parse.statement;

    bit call (StructExp o) { return call (cast (Expression) o); }
    bit call (AssertExp o) { return call (cast (Expression) o); }
    bit call (BitwiseXorExp o) { return call (cast (BinaryExp) o); }
    bit call (BitwiseXorAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (BitwiseOrAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (BitwiseAndAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (ModExp o) { return call (cast (BinaryExp) o); }
    bit call (ModAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (UnsignedRightShiftAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (RightShiftAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (MulAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (ArrayLengthExp o) { return call (cast (Expression) o); }
    bit call (ExpStatement o) { return call (cast (Statement) o); }
    bit call (ThrowStatement o) { return call (cast (Statement) o); }
    bit call (DefaultStatement o) { return call (cast (Statement) o); }
    bit call (CaseStatement o) { return call (cast (Statement) o); }
    bit call (SwitchStatement o) { return call (cast (Statement) o); }
    bit call (WhileStatement o) { return call (cast (Statement) o); }
    bit call (ReturnStatement o) { return call (cast (Statement) o); }
    bit call (IfElseStatement o) { return call (cast (Statement) o); }
    bit call (BlockStatement o) { return call (cast (Statement) o); }
    bit call (LabelStatement o) { return call (cast (Statement) o); }
    bit call (ForStatement o) { return call (cast (Statement) o); }
    bit call (WithStatement o) { return call (cast (Statement) o); }
    bit call (VolatileStatement o) { return call (cast (Statement) o); }
    bit call (VariableDeclaration o) { return call (cast (Declaration) o); }
    bit call (UnittestDeclaration o) { return call (cast (FunctionDeclaration) o); }
    bit call (ConstructorDeclaration o) { return call (cast (FunctionDeclaration) o); }
    bit call (FunctionDeclaration o) { return call (cast (Declaration) o); }
    bit call (AliasDeclaration o) { return call (cast (Declaration) o); }
    bit call (EnumDeclaration o) { return call (cast (Declaration) o); }
    bit call (ClassDeclaration o) { return call (cast (AggregateDeclaration) o); }
    bit call (StructDeclaration o) { return call (cast (AggregateDeclaration) o); }
    bit call (AggregateDeclaration o) { return call (cast (Declaration) o); }
    bit call (ImportDeclaration o) { return call (cast (Declaration) o); }
    bit call (Declaration o) { return call (cast (Statement) o); }
    bit call (BitwiseAndExp o) { return call (cast (BinaryExp) o); }
    bit call (BitwiseOrExp o) { return call (cast (BinaryExp) o); }
    bit call (UnsignedRightShiftExp o) { return call (cast (BinaryExp) o); }
    bit call (RightShiftExp o) { return call (cast (BinaryExp) o); }
    bit call (LeftShiftAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (LeftShiftExp o) { return call (cast (BinaryExp) o); }
    bit call (CatAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (CatExp o) { return call (cast (BinaryExp) o); }
    bit call (InExp o) { return call (cast (BinaryExp) o); }
    bit call (LogicalAndExp o) { return call (cast (BinaryExp) o); }
    bit call (LogicalOrExp o) { return call (cast (BinaryExp) o); }
    bit call (CompareExp o) { return call (cast (BinaryExp) o); }
    bit call (IdentityEqualsExp o) { return call (cast (BinaryExp) o); }
    bit call (EqualsExp o) { return call (cast (BinaryExp) o); }
    bit call (IndexExp o) { return call (cast (BinaryExp) o); }
    bit call (DivAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (DivExp o) { return call (cast (BinaryExp) o); }
    bit call (MulExp o) { return call (cast (BinaryExp) o); }
    bit call (SubAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (SubExp o) { return call (cast (BinaryExp) o); }
    bit call (AddAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (AddExp o) { return call (cast (BinaryExp) o); }
    bit call (AssignExp o) { return call (cast (BinaryExp) o); }
    bit call (CommaExp o) { return call (cast (BinaryExp) o); }
    bit call (BinaryExp o) { return call (cast (UnaryExp) o); }
    bit call (LogicalNotExp o) { return call (cast (PreUnaryExp) o); }
    bit call (PointerExp o) { return call (cast (PreUnaryExp) o); }
    bit call (AddressExp o) { return call (cast (PreUnaryExp) o); }
    bit call (PreDecExp o) { return call (cast (PreUnaryExp) o); }
    bit call (PreIncExp o) { return call (cast (PreUnaryExp) o); }
    bit call (PostDecExp o) { return call (cast (UnaryExp) o); }
    bit call (PostIncExp o) { return call (cast (UnaryExp) o); }
    bit call (NegExp o) { return call (cast (UnaryExp) o); }
    bit call (PreUnaryExp o) { return call (cast (UnaryExp) o); }
    bit call (UnaryExp o) { return call (cast (Expression) o); }
    bit call (ConditionalExp o) { return call (cast (Expression) o); }
    bit call (ArrayExp o) { return call (cast (Expression) o); }
    bit call (DotIdExp o) { return call (cast (Expression) o); }
    bit call (SliceExp o) { return call (cast (Expression) o); }
    bit call (TypeDotIdExp o) { return call (cast (Expression) o); }
    bit call (CastExp o) { return call (cast (Expression) o); }
    bit call (NewExp o) { return call (cast (CallExp) o); }
    bit call (CallExp o) { return call (cast (Expression) o); }
    bit call (NullExp o) { return call (cast (Expression) o); }
    bit call (SuperExp o) { return call (cast (SuperExp) o); }
    bit call (ThisExp o) { return call (cast (Expression) o); }
    bit call (IdExp o) { return call (cast (Expression) o); }
    bit call (StringExp o) { return call (cast (Expression) o); }
    bit call (FalseExp o) { return call (cast (IntegerExp) o); }
    bit call (TrueExp o) { return call (cast (IntegerExp) o); }
    bit call (ImaginaryExp o) { return call (cast (Expression) o); }
    bit call (FloatExp o) { return call (cast (Expression) o); }
    bit call (IntegerExp o) { return call (cast (Expression) o); }
    bit call (Expression o) { return callobj (cast (Object) o); }
    bit call (Module o) { return call (cast (Scope) o); }
    bit call (Symbol o) { return callobj (cast (Object) o); }
    bit call (Scope o) { return callobj (cast (Object) o); }
    bit call (Statement o) { return base (o.scope) && callobj (cast (Object) o); }
    bit callobj (Object o) { return true; }

/+
#endif
+/
}

/** Throw unimplemented errors if anything falls through. */
class RigidDispatch : Dispatch
{
/+
#ifndef DOXYGEN_SHOULD_SKIP_THIS
+/

    bit call (StructExp o) { throw new Error (this.classinfo.name ~ ": StructExp"); return false; }
    bit call (AssertExp o) { throw new Error (this.classinfo.name ~ ": AssertExp"); return false; }
    bit call (BitwiseXorExp o) { throw new Error (this.classinfo.name ~ ": BitwiseXorExp"); return false; }
    bit call (BitwiseXorAssignExp o) { throw new Error (this.classinfo.name ~ ": BitwiseXorAssignExp"); return false; }
    bit call (BitwiseOrAssignExp o) { throw new Error (this.classinfo.name ~ ": BitwiseOrAssignExp"); return false; }
    bit call (BitwiseAndAssignExp o) { throw new Error (this.classinfo.name ~ ": BitwiseAndAssignExp"); return false; }
    bit call (ModExp o) { throw new Error (this.classinfo.name ~ ": ModExp"); return false; }
    bit call (ModAssignExp o) { throw new Error (this.classinfo.name ~ ": ModAssignExp"); return false; }
    bit call (UnsignedRightShiftAssignExp o) { throw new Error (this.classinfo.name ~ ": UnsignedRightShiftAssignExp"); return false; }
    bit call (RightShiftAssignExp o) { throw new Error (this.classinfo.name ~ ": RightShiftAssignExp"); return false; }
    bit call (MulAssignExp o) { throw new Error (this.classinfo.name ~ ": MulAssignExp"); return false;  }
    bit call (ArrayLengthExp o) { throw new Error (this.classinfo.name ~ ": ArrayLengthExp"); return false; }
    bit call (ExpStatement o) { throw new Error (this.classinfo.name ~ ": ExpStatement"); return false; }
    bit call (ThrowStatement o) { throw new Error (this.classinfo.name ~ ": ThrowStatement"); return false; }
    bit call (DefaultStatement o) { throw new Error (this.classinfo.name ~ ": DefaultStatement"); return false; }
    bit call (CaseStatement o) { throw new Error (this.classinfo.name ~ ": CaseStatement"); return false; }
    bit call (SwitchStatement o) { throw new Error (this.classinfo.name ~ ": SwitchStatement"); return false; }
    bit call (WhileStatement o) { throw new Error (this.classinfo.name ~ ": WhileStatement"); return false; }
    bit call (ReturnStatement o) { throw new Error (this.classinfo.name ~ ": ReturnStatement"); return false; }
    bit call (IfElseStatement o) { throw new Error (this.classinfo.name ~ ": IfElseStatement"); return false; }
    bit call (BlockStatement o) { throw new Error (this.classinfo.name ~ ": BlockStatement"); return false; }
    bit call (LabelStatement o) { throw new Error (this.classinfo.name ~ ": LabelStatement"); return false; }
    bit call (ForStatement o) { throw new Error (this.classinfo.name ~ ": ForStatement"); return false; }
    bit call (WithStatement o) { throw new Error (this.classinfo.name ~ ": WithStatement"); return false; }
    bit call (VolatileStatement o) { throw new Error (this.classinfo.name ~ ": VolatileStatement"); return false; }
    bit call (VariableDeclaration o) { throw new Error (this.classinfo.name ~ ": VariableDeclaration"); return false; }
    bit call (UnittestDeclaration o) { throw new Error (this.classinfo.name ~ ": UnittestDeclaration"); return false; }
    bit call (ConstructorDeclaration o) { throw new Error (this.classinfo.name ~ ": ConstructorDeclaration"); return false; }
    bit call (FunctionDeclaration o) { throw new Error (this.classinfo.name ~ ": FunctionDeclaration"); return false; }
    bit call (AliasDeclaration o) { throw new Error (this.classinfo.name ~ ": AliasDeclaration"); return false; }
    bit call (EnumDeclaration o) { throw new Error (this.classinfo.name ~ ": EnumDeclaration"); return false; }
    bit call (ClassDeclaration o) { throw new Error (this.classinfo.name ~ ": ClassDeclaration"); return false; }
    bit call (StructDeclaration o) { throw new Error (this.classinfo.name ~ ": StructDeclaration"); return false; }
    bit call (AggregateDeclaration o) { throw new Error (this.classinfo.name ~ ": AggregateDeclaration"); return false; }
    bit call (ImportDeclaration o) { throw new Error (this.classinfo.name ~ ": ImportDeclaration"); return false; }
    bit call (Declaration o) { throw new Error (this.classinfo.name ~ ": Declaration"); return false; }
    bit call (BitwiseAndExp o) { throw new Error (this.classinfo.name ~ ": BitwiseAndExp"); return false; }
    bit call (BitwiseOrExp o) { throw new Error (this.classinfo.name ~ ": BitwiseOrExp"); return false; }
    bit call (UnsignedRightShiftExp o) { throw new Error (this.classinfo.name ~ ": UnsignedRightShiftExp"); return false; }
    bit call (RightShiftExp o) { throw new Error (this.classinfo.name ~ ": RightShiftExp"); return false; }
    bit call (LeftShiftAssignExp o) { throw new Error (this.classinfo.name ~ ": LeftShiftAssignExp"); return false; }
    bit call (LeftShiftExp o) { throw new Error (this.classinfo.name ~ ": LeftShiftExp"); return false; }
    bit call (CatAssignExp o) { throw new Error (this.classinfo.name ~ ": CatAssignExp"); return false; }
    bit call (CatExp o) { throw new Error (this.classinfo.name ~ ": CatExp"); return false; }
    bit call (InExp o) { throw new Error (this.classinfo.name ~ ": InExp"); return false; }
    bit call (LogicalAndExp o) { throw new Error (this.classinfo.name ~ ": LogicalAndExp"); return false; }
    bit call (LogicalOrExp o) { throw new Error (this.classinfo.name ~ ": LogicalOrExp"); return false; }
    bit call (CompareExp o) { throw new Error (this.classinfo.name ~ ": CompareExp"); return false; }
    bit call (IdentityEqualsExp o) { throw new Error (this.classinfo.name ~ ": IdentityEqualsExp"); return false; }
    bit call (EqualsExp o) { throw new Error (this.classinfo.name ~ ": EqualsExp"); return false; }
    bit call (IndexExp o) { throw new Error (this.classinfo.name ~ ": IndexExp"); return false; }
    bit call (DivAssignExp o) { throw new Error (this.classinfo.name ~ ": DivAssignExp"); return false; }
    bit call (DivExp o) { throw new Error (this.classinfo.name ~ ": DivExp"); return false; }
    bit call (MulExp o) { throw new Error (this.classinfo.name ~ ": MulExp"); return false; }
    bit call (SubAssignExp o) { throw new Error (this.classinfo.name ~ ": SubAssignExp"); return false; }
    bit call (SubExp o) { throw new Error (this.classinfo.name ~ ": SubExp"); return false; }
    bit call (AddAssignExp o) { throw new Error (this.classinfo.name ~ ": AddAssignExp"); return false; }
    bit call (AddExp o) { throw new Error (this.classinfo.name ~ ": AddExp"); return false; }
    bit call (AssignExp o) { throw new Error (this.classinfo.name ~ ": AssignExp"); return false; }
    bit call (CommaExp o) { throw new Error (this.classinfo.name ~ ": CommaExp"); return false; }
    bit call (BinaryExp o) { throw new Error (this.classinfo.name ~ ": BinaryExp"); return false; }
    bit call (LogicalNotExp o) { throw new Error (this.classinfo.name ~ ": LogicalNotExp"); return false; }
    bit call (PointerExp o) { throw new Error (this.classinfo.name ~ ": PointerExp"); return false; }
    bit call (AddressExp o) { throw new Error (this.classinfo.name ~ ": AddressExp"); return false; }
    bit call (PreDecExp o) { throw new Error (this.classinfo.name ~ ": PreDecExp"); return false; }
    bit call (PreIncExp o) { throw new Error (this.classinfo.name ~ ": PreIncExp"); return false; }
    bit call (PostDecExp o) { throw new Error (this.classinfo.name ~ ": PostDecExp"); return false; }
    bit call (PostIncExp o) { throw new Error (this.classinfo.name ~ ": PostIncExp"); return false; }
    bit call (NegExp o) { throw new Error (this.classinfo.name ~ ": NegExp"); return false; }
    bit call (PreUnaryExp o) { throw new Error (this.classinfo.name ~ ": PreUnaryExp"); return false; }
    bit call (UnaryExp o) { throw new Error (this.classinfo.name ~ ": UnaryExp"); return false; }
    bit call (ConditionalExp o) { throw new Error (this.classinfo.name ~ ": ConditionalExp"); return false; }
    bit call (ArrayExp o) { throw new Error (this.classinfo.name ~ ": ArrayExp"); return false; }
    bit call (DotIdExp o) { throw new Error (this.classinfo.name ~ ": DotIdExp"); return false; }
    bit call (SliceExp o) { throw new Error (this.classinfo.name ~ ": SliceExp"); return false; }
    bit call (TypeDotIdExp o) { throw new Error (this.classinfo.name ~ ": TypeDotIdExp"); return false; }
    bit call (CastExp o) { throw new Error (this.classinfo.name ~ ": CastExp"); return false; }
    bit call (NewExp o) { throw new Error (this.classinfo.name ~ ": NewExp"); return false; }
    bit call (CallExp o) { throw new Error (this.classinfo.name ~ ": CallExp"); return false; }
    bit call (NullExp o) { throw new Error (this.classinfo.name ~ ": NullExp"); return false; }
    bit call (SuperExp o) { throw new Error (this.classinfo.name ~ ": SuperExp"); return false; }
    bit call (ThisExp o) { throw new Error (this.classinfo.name ~ ": ThisExp"); return false; }
    bit call (IdExp o) { throw new Error (this.classinfo.name ~ ": IdExp"); return false; }
    bit call (StringExp o) { throw new Error (this.classinfo.name ~ ": StringExp"); return false; }
    bit call (FalseExp o) { throw new Error (this.classinfo.name ~ ": FalseExp"); return false; }
    bit call (TrueExp o) { throw new Error (this.classinfo.name ~ ": TrueExp"); return false; }
    bit call (ImaginaryExp o) { throw new Error (this.classinfo.name ~ ": ImaginaryExp"); return false; }
    bit call (FloatExp o) { throw new Error (this.classinfo.name ~ ": FloatExp"); return false; }
    bit call (IntegerExp o) { throw new Error (this.classinfo.name ~ ": IntegerExp"); return false; }
    bit call (Expression o) { throw new Error (this.classinfo.name ~ ": " ~ o.classinfo.name ~ ": Expression"); return false; }
    bit call (Module o) { throw new Error (this.classinfo.name ~ ": Module"); return false; }
    bit call (Symbol o) { throw new Error (this.classinfo.name ~ ": Symbol"); return false; }
    bit call (Scope o) { throw new Error (this.classinfo.name ~ ": Scope"); return false; }
    bit call (Statement o) { throw new Error (this.classinfo.name ~ ": Statement"); return false; }
    bit callobj (Object o) { throw new Error (this.classinfo.name ~ ": Object"); return false; }

/+
#endif
+/
}

/** Recursively walk an object, walking along its children. */
class WalkDispatch : RigidDispatch
{
    Dispatch other;
    bit delegate (Object o) del;
    bit delset;

    /** Setup another dispatch to take these messages. */
    this (Dispatch other)
    {
        this.other = other;
    }

    /** Setup a delegate to take these messages. */
    this (bit delegate (Object o) del)
    {
        this.del = del;
        this.delset = true;
    }

    bit base (Object o)
    {
        if (o === null)
            return true;
        if (delset && !del (o))
            return false;
        if (other !== null && !other.base (o))
            return false;
        return super.base (o);
    }

    /** WalkDispatch takes no control of this if other is given. */
    bit baselist (Object [] list)
    {
        if (other !== null)
            return other.baselist (list);
        return super.baselist (list);
    }

    bit baselistBase (Object [] list)
    {
        return super.baselist (list);
    }

/+
#ifndef DOXYGEN_SHOULD_SKIP_THIS
+/

    bit call (StructExp o) { return call (cast (Expression) o); }
    bit call (BitwiseXorExp o) { return call (cast (BinaryExp) o); }
    bit call (BitwiseXorAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (BitwiseOrAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (BitwiseAndAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (ModExp o) { return call (cast (BinaryExp) o); }
    bit call (ModAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (UnsignedRightShiftAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (RightShiftAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (MulAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (ArrayLengthExp o) { return base (o.a) && call (cast (Expression) o); }
    bit call (ExpStatement o) { return base (o.exp) && call (cast (Statement) o); }
    bit call (ThrowStatement o) { return base (o.value) && call (cast (Statement) o); }
    bit call (DefaultStatement o) { return call (cast (Statement) o); }
    bit call (CaseStatement o) { return base (o.value) && call (cast (Statement) o); }
    bit call (SwitchStatement o) { return base (o.value) && base (o.content) && call (cast (Statement) o); }
    bit call (WhileStatement o) { return base (o.test) && base (o.content) && call (cast (Statement) o); }
    bit call (ReturnStatement o) { return base (o.value) && call (cast (Statement) o); }
    bit call (IfElseStatement o) { return base (o.test) && base (o.onTrue) && base (o.onFalse) && call (cast (Statement) o); }
    bit call (BlockStatement o) { return call (cast (Statement) o); }
    bit call (LabelStatement o) { return base (o.name) && call (cast (Statement) o); }
    bit call (ForStatement o) { return base (o.init) && base (o.test) && base (o.incr) && base (o.content) && call (cast (Statement) o); }
    bit call (WithStatement o) { return base (o.object) && base (o.content) && call (cast (Statement) o); }
    bit call (VolatileStatement o) { return base (o.content) && call (cast (Statement) o); }
    bit call (VariableDeclaration o) { return baselist ((Object []) o.list) && call (cast (Declaration) o); }
    bit call (UnittestDeclaration o) { return call (cast (FunctionDeclaration) o); }
    bit call (ConstructorDeclaration o) { return call (cast (FunctionDeclaration) o); }
    bit call (FunctionDeclaration o) { if (!base (o.type) || !base (o.name) || !base (o.inStatement) || !base (o.outStatement) || !base (o.outReturn) || !base (o.bodyStatement) || !call (cast (Declaration) o)) return false; return true; }
    bit call (AliasDeclaration o) { return base (o.type) && base (o.name) && call (cast (Declaration) o); }
    bit call (EnumDeclaration o) { return base (o.type) && base (o.name) && baselist (cast (Object []) o.list) && call (cast (Declaration) o); }
    bit call (ClassDeclaration o) { return call (cast (AggregateDeclaration) o); }
    bit call (StructDeclaration o) { return call (cast (AggregateDeclaration) o); }
    bit call (AggregateDeclaration o) { return base (o.supertype) && base (o.name) && base (o.scope) && call (cast (Declaration) o); }
    bit call (ImportDeclaration o) { return baselist (cast (Object []) o.names) && call (cast (Declaration) o); }
    bit call (Declaration o) { return true; }
    bit call (BitwiseAndExp o) { return call (cast (BinaryExp) o); }
    bit call (BitwiseOrExp o) { return call (cast (BinaryExp) o); }
    bit call (UnsignedRightShiftExp o) { return call (cast (BinaryExp) o); }
    bit call (RightShiftExp o) { return call (cast (BinaryExp) o); }
    bit call (LeftShiftAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (LeftShiftExp o) { return call (cast (BinaryExp) o); }
    bit call (CatAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (CatExp o) { return call (cast (BinaryExp) o); }
    bit call (InExp o) { return call (cast (BinaryExp) o); }
    bit call (LogicalAndExp o) { return call (cast (BinaryExp) o); }
    bit call (LogicalOrExp o) { return call (cast (BinaryExp) o); }
    bit call (CompareExp o) { return call (cast (BinaryExp) o); }
    bit call (IdentityEqualsExp o) { return call (cast (BinaryExp) o); }
    bit call (EqualsExp o) { return call (cast (BinaryExp) o); }
    bit call (IndexExp o) { return call (cast (BinaryExp) o); }
    bit call (DivAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (DivExp o) { return call (cast (BinaryExp) o); }
    bit call (MulExp o) { return call (cast (BinaryExp) o); }
    bit call (SubAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (SubExp o) { return call (cast (BinaryExp) o); }
    bit call (AddAssignExp o) { return call (cast (BinaryExp) o); }
    bit call (AddExp o) { return call (cast (BinaryExp) o); }
    bit call (AssignExp o) { return call (cast (BinaryExp) o); }
    bit call (CommaExp o) { return call (cast (BinaryExp) o); }
    bit call (BinaryExp o) { return base (o.b) && call (cast (UnaryExp) o); }
    bit call (LogicalNotExp o) { return call (cast (PreUnaryExp) o); }
    bit call (PointerExp o) { return call (cast (PreUnaryExp) o); }
    bit call (AddressExp o) { return call (cast (PreUnaryExp) o); }
    bit call (PreDecExp o) { return call (cast (PreUnaryExp) o); }
    bit call (PreIncExp o) { return call (cast (PreUnaryExp) o); }
    bit call (PostDecExp o) { return call (cast (UnaryExp) o); }
    bit call (PostIncExp o) { return call (cast (UnaryExp) o); }
    bit call (NegExp o) { return call (cast (UnaryExp) o); }
    bit call (PreUnaryExp o) { return call (cast (UnaryExp) o); }
    bit call (UnaryExp o) { return base (o.a) && call (cast (Expression) o); }
    bit call (ConditionalExp o) { return base (o.test) && base (o.onTrue) && base (o.onFalse) && call (cast (Expression) o); }
    bit call (ArrayExp o) { for (int c; c < o.list.length; c ++) if (!base (o.list [c].index) || !base (o.list [c].value)) return false; return call (cast (Expression) o); }
    bit call (DotIdExp o) { return base (o.a) && base (o.symbol) && call (cast (Expression) o); }
    bit call (SliceExp o) { return base (o.array) && base (o.start) && base (o.end) && call (cast (Expression) o); }
    bit call (TypeDotIdExp o) { return base (o.at) && call (cast (Expression) o); }
    bit call (CastExp o) { return base (o.a) && call (cast (Expression) o); }
    bit call (NewExp o) { return call (cast (CallExp) o); }
    bit call (CallExp o) { return base (o.a) && baselist ((Object []) o.args) && call (cast (Expression) o); }
    bit call (NullExp o) { return call (cast (Expression) o); }
    bit call (SuperExp o) { return call (cast (Expression) o); }
    bit call (ThisExp o) { return call (cast (Expression) o); }
    bit call (IdExp o) { return call (cast (Expression) o); }
    bit call (StringExp o) { return call (cast (Expression) o); }
    bit call (FalseExp o) { return call (cast (IntegerExp) o); }
    bit call (TrueExp o) { return call (cast (IntegerExp) o); }
    bit call (ImaginaryExp o) { return call (cast (Expression) o); }
    bit call (FloatExp o) { return call (cast (Expression) o); }
    bit call (IntegerExp o) { return call (cast (Expression) o); }
    bit call (Expression o) { return base (o.type) && callobj (cast (Object) o); }
    bit call (Module o) { return base (o.parser) && call (cast (Scope) o); }
    bit call (Symbol o) { return base (o.type) && base (o.init); }
    bit call (Scope o) { return baselist ((Object []) o.list); }
    bit call (Statement o) { return true; }
    bit callobj (Object o) { return true; }

/+
#endif
+/
}

/** Produce a class type tree. */
class ClassTreePrintDispatch : Dispatch
{
    WalkDispatch walker;
    int depth = 0;
    Object [Object] hit;

    this ()
    {
        walker = new WalkDispatch (this);
    }

    void print (int indent, char [] text)
    {
        printf ("%*s%.*s\n", depth * 2, (char *) "", text);
    }

    bit base (Object o)
    {
        if (o === null)
            return true;
        if (o in hit)
            return true;
        hit [o] = o;
        print (depth, o.classinfo.name);
        depth ++;
        walker.base (o);
        depth --;
        return true;
    }

    bit baselist (Object [] list)
    {
        for (int c; ; c ++)
        {
            if (c >= list.length)
                return true;

            if (!(list [c] in hit))
                break;
        }

        if (!list.length)
        {
            print (depth, "[ ]");
            return true;
        }

        print (depth, "[");
        depth ++;
        walker.baselistBase (list);
        depth --;
        print (depth, "]");
        return true;
    }
}